//
//  MCSourceListEditor.h
//  MCApplication
//
//  Created by Michael Clark on Wed Jul 28 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCSwitchView.h"
#import "MCWindowController.h"

#import <MCFoundation/MCSourceList.h>
#import <MCFoundation/MCSourceListDefines.h>


#define MCSourceListEditorModeCreate  1
#define MCSourceListEditorModeEdit    2

@class MCQueryBuilderView, MCSLEAbstractConfigView,MCHelpController;

@interface MCSourceListEditor : MCWindowController {
	IBOutlet NSView*                placeHolder;
	IBOutlet NSButton*              smartListPushButton;
	IBOutlet NSTextField*           smartTitle;
	
	IBOutlet NSObjectController*    valuesController;
	
	MCSLEAbstractConfigView*        _configView;
	
	id <MCSourceList>               _editingSourceList;
	NSMutableDictionary*            _values;
	MCSourceListType                _type;
	NSArray*                        _preLinkedObjects;
	
	int                             _mode; 
	
	
	// TEMP
	IBOutlet NSArrayController*      tempTeamsController;
	IBOutlet NSWindow*               permissionsWindow;

	IBOutlet NSButton                *helpButton;
}

- (void)runCreationForIdentifier: (NSString*)anIdentifier sourceListType:(MCSourceListType)aType 
				preLinkedObjects:(NSArray *)objs;
- (void)runCreationForIdentifier: (NSString*)anIdentifier sourceListType:(MCSourceListType)aType;
- (void)runCreationForIdentifier: (NSString*)anIdentifier;
- (void)runEditWithSourceList: (id <MCSourceList>)aSourceList;

- (IBAction)done: (id)sender;
- (IBAction)cancel: (id)sender;
//- (IBAction)toggleSmartList: (id)sender;
//- (IBAction)toggleWatchList: (id)sender;

// TEMP
- (IBAction)runPermissionsSheet: (id)sender;
- (IBAction)cancelPermissionsSheet: (id)sender;

// UI bindings
- (NSString *)doneButtonTitle;

// Accessors
- (NSMutableDictionary *)values;
- (void)setValues:(NSMutableDictionary *)aValues;

- (NSArray *)preLinkedObjects;
- (void)setPreLinkedObjects:(NSArray *)aPreLinkedObjects;
@end
